<?php
declare(strict_types=1);

// Autoload (very small)
spl_autoload_register(function ($class) {
    $prefix = 'App\\';
    if (strncmp($class, $prefix, strlen($prefix)) !== 0) return;
    $relative = substr($class, strlen($prefix));
    $file = __DIR__ . '/' . str_replace('\\', '/', $relative) . '.php';
    if (file_exists($file)) require_once $file;
});

// Load env (.env) if present
App\Support\Env::load(__DIR__ . '/../.env');

// Error handling
ini_set('display_errors', '0');
error_reporting(E_ALL);

set_exception_handler(function ($e) {
    App\Support\Logger::error('Unhandled exception', [
        'type' => get_class($e),
        'message' => $e->getMessage(),
        'file' => $e->getFile(),
        'line' => $e->getLine(),
    ]);
    http_response_code(500);
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode(['error' => 'internal_error']);
    exit;
});
