<?php
declare(strict_types=1);
namespace App\Support;

final class Env
{
    private static array $data = [];

    public static function load(string $path): void {
        if (!file_exists($path)) return;
        $lines = file($path, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
        foreach ($lines as $line) {
            $line = trim($line);
            if ($line === '' || str_starts_with($line, '#')) continue;
            $parts = explode('=', $line, 2);
            if (count($parts) !== 2) continue;
            $k = trim($parts[0]);
            $v = trim($parts[1]);
            $v = trim($v, "\"'");
            self::$data[$k] = $v;
            $_ENV[$k] = $v;
        }
    }

    public static function get(string $key): ?string {
        if (array_key_exists($key, self::$data)) return self::$data[$key];
        if (isset($_ENV[$key])) return (string) $_ENV[$key];
        $v = getenv($key);
        return $v === false ? null : (string) $v;
    }
}
