<?php
declare(strict_types=1);
namespace App\Support;

final class Crypto
{
    public static function randomHex(int $bytes = 32): string {
        return bin2hex(random_bytes($bytes));
    }

    public static function hashPassword(string $password): string {
        return password_hash($password, PASSWORD_DEFAULT);
    }

    public static function verifyPassword(string $password, string $hash): bool {
        return password_verify($password, $hash);
    }

    public static function hmac(string $payload, string $secret): string {
        return hash_hmac('sha256', $payload, $secret);
    }
}
