<?php
declare(strict_types=1);
namespace App\Http;

final class Router
{
    private array $routes = [];

    public function get(string $path, $handler): void { $this->map('GET', $path, $handler); }
    public function post(string $path, $handler): void { $this->map('POST', $path, $handler); }

    private function map(string $method, string $path, $handler): void {
        $key = $method . ' ' . rtrim($path, '/') ?: '/';
        $this->routes[$key] = $handler;
    }

    public function dispatch(): void {
        $method = Request::method();
        $path = Request::path();
        $key = $method . ' ' . $path;
        if (!isset($this->routes[$key])) {
            Response::json(['error' => 'not_found', 'path' => $path], 404);
        }
        $handler = $this->routes[$key];

        if (is_callable($handler)) {
            $handler();
            return;
        }
        if (is_array($handler) && count($handler) === 2) {
            [$class, $methodName] = $handler;
            $obj = new $class();
            $obj->$methodName();
            return;
        }
        Response::json(['error' => 'invalid_route_handler'], 500);
    }
}
