<?php
declare(strict_types=1);
namespace App\Controllers;

use App\Http\Response;
use App\Support\DB;

final class AdminController
{
    public function dashboard(): void
    {
        $counts = [
            'users' => (int)(DB::one("SELECT COUNT(*) c FROM users")['c'] ?? 0),
            'accounts' => (int)(DB::one("SELECT COUNT(*) c FROM accounts")['c'] ?? 0),
            'transfers' => (int)(DB::one("SELECT COUNT(*) c FROM transfers")['c'] ?? 0),
            'payment_links' => (int)(DB::one("SELECT COUNT(*) c FROM payment_links")['c'] ?? 0),
            'webhook_events' => (int)(DB::one("SELECT COUNT(*) c FROM webhook_events")['c'] ?? 0),
        ];

        $html = "<h1>Fintech Admin</h1><pre>" . htmlspecialchars(json_encode($counts, JSON_PRETTY_PRINT|JSON_UNESCAPED_UNICODE)) . "</pre>";
        $html .= "<p>Tip: protegé /admin con .htpasswd o un login propio.</p>";
        Response::html($html);
    }
}
