<?php
declare(strict_types=1);
namespace App;

final class Config
{
    public static function env(string $key, $default = null) {
        $v = \App\Support\Env::get($key);
        return $v !== null ? $v : $default;
    }

    public static function app(): array {
        return [
            'env' => self::env('APP_ENV', 'production'),
            'url' => self::env('APP_URL', ''),
            'key' => self::env('APP_KEY', ''),
            'timezone' => self::env('APP_TIMEZONE', 'America/Argentina/Buenos_Aires'),
        ];
    }

    public static function db(): array {
        return [
            'host' => self::env('DB_HOST', 'localhost'),
            'name' => self::env('DB_NAME', ''),
            'user' => self::env('DB_USER', ''),
            'pass' => self::env('DB_PASS', ''),
            'port' => (int) self::env('DB_PORT', '3306'),
        ];
    }

    public static function openpass(): array {
        return [
            'base_url' => rtrim((string) self::env('OPENPASS_BASE_URL', ''), '/'),
            'username' => (string) self::env('OPENPASS_USERNAME', ''),
            'password' => (string) self::env('OPENPASS_PASSWORD', ''),
            'application_id' => (string) self::env('OPENPASS_APPLICATION_ID', ''),
            'device_id' => (string) self::env('OPENPASS_DEVICE_ID', ''),
        ];
    }

    public static function webhooks(): array {
        return [
            'openpass_secret' => (string) self::env('WEBHOOK_OPENPASS_SECRET', ''),
        ];
    }
}
