# Fintech (OpenPass BHUB) – Starter para cPanel (PHP + MySQL)

Este proyecto es un *starter* listo para subir a cPanel y empezar a integrar con OpenPass BHUB.

## Qué incluye
- API mínima (PHP) con router por `.htaccess`
- Autenticación local (register/login) con token tipo Bearer
- Integración base con OpenPass (`POST /login` + header `accessToken`)
- Esqueletos de endpoints: cuentas, transferencias, payment links
- Receptor de webhooks `/webhooks/openpass`
- Admin simple `/admin`
- Esquema SQL (MySQL/MariaDB) en `database/schema.sql`

## Requisitos
- PHP 8.0+ (ideal 8.1/8.2)
- MySQL/MariaDB + phpMyAdmin
- Mod_Rewrite habilitado (estándar en cPanel)

## Instalación en cPanel (paso a paso)
1. **Crear BD y usuario** en cPanel (MySQL Databases) y asignar permisos.
2. Importar `database/schema.sql` en phpMyAdmin.
3. Subir todo el proyecto a tu hosting (por ejemplo en `/home/USER/fintech/`).
4. En el dominio/subdominio, setear el **Document Root** apuntando a la carpeta `public/`.
   - Ej: `/home/USER/fintech/public`
5. Copiar `.env.example` a `.env` y completar credenciales (DB + OpenPass).
6. Probar: `GET /health`

## Endpoints (demo)
- `POST /api/auth/register` { email, password, dni }
- `POST /api/auth/login` { email, password } -> { token }
- `GET /api/accounts` (Authorization: Bearer <token>)
- `POST /api/accounts` (Authorization) -> llama a OpenPass (placeholder endpoint)
- `POST /api/transfers` (Authorization)
- `POST /api/payment-links` (Authorization)
- `POST /webhooks/openpass` (opcional firma HMAC con `X-Signature`)

## Importante
Este starter es intencionalmente simple para que corra en hosting compartido.
Para producción bancaria real: agregá KYC, límites, doble factor, antifraude, conciliación, auditoría, y hardening.
